/*
 * File:   main.c
 * Author: Y.Sakazume
 *
 * Ignition signal distributer Ver.2
 *
 * Device: 12F609
 * H/W connection:
 * GP0      Cylinder1 IG output
 * GP1		Cylinder2 IG output
 * GP2      Cylinder3 IG output
 * GP3      IGT input
 * GP4  	G1 input
 * GP5      Cylinder4 IG output
 */
#include <xc.h>
#include <stdbool.h>
#define _XTAL_FREQ  8000000

// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

// CONFIG
#pragma config IDLOC0 = 0x3, IDLOC1 = 0x1, IDLOC2 = 0x0, IDLOC3 = 0x0;
#pragma config FOSC = INTOSCIO, IOSCFS = 8MHZ       // Oscillator Selection bits
#pragma config WDTE = OFF       // Watchdog Timer (WDT disabled)
#pragma config PWRTE = ON       // Power-up Timer Enable bit (Power-up Timer is enabled)
#pragma config CP = OFF         // Code Protection bit (Code protection disabled)
#pragma config MCLRE = OFF

#define IGT GP3
#define G1 GP4
#define CLR GPIO=0

static bool g0_flg=0;
static char i;
static char data[]={0x01,0x02,0x04,0x20};
    
void __interrupt() ISR(void) {
    //GIE=0;               // prohibit INT automatically
    if(CMIF == 1){
//        __delay_ms(2);      // noise margin
        if(G1 == 0){
            g0_flg=1;
            i=0;
        }
        CMIF=0;
        GIE=1;
    }
    else if(GPIF == 1){
        if (i > 3)         // G1 signal failure
            g0_flg=0;
        GPIE=0;
        GIE=1;          // enable CMIE
        if(IGT) {
            if(g0_flg)
                GPIO=data[i++];
            else
                GPIO=0x27;
        }
        else
            CLR;
        __delay_ms(1);
        GPIF=0;         // can nt clear after fetching of GPIO
        GPIE=1;
    }
}

void main(void) {
    ANSEL = 0x08;      // set GP4 to analog
    CMCON0 = 0b10000101;       // comparator setup
    //CMHYS = 1;
    VRCON = 0b100011111;   // reference voltage = 3/4*Vdd = 2.5V
    //VRCON = 0b0010000;      // reference voltage = 0.6V
    TRISIO=0x18;
    IOC3 = 1;
    CMIE = 1;
    INTCON=0xc8;
    
    while(1){
        SLEEP();
    }
}

